//-----------------------------------------------------
//restore save button
function restoreSaveButton(){	
	$("#spanLoaderSave").hide();
	$("#spanErrorText").hide();
	$("#spanSavedText").hide();
	$("#butSaveSettings").show();
}

//-----------------------------------------------------
//show saving error text
function showSavingErrorText(){
   $("#butSaveSettings").show();
   $("#spanErrorText").show();
   setTimeout("restoreSaveButton()",5000);
}

//-----------------------------------------------------
//show restoring error text
function showRestoreErrorText(){
	$("#spanRestoreErrorText").show();
	$("#butRestoreSettings").show();
	$("#spanLoaderRestore").hide();
}

//-----------------------------------------------------
//save the settings
function saveSettingsClick(formID){
	if(!formID) formID = "frmSettings";
	
	var objForm = getObjFormElements(formID);
	var obj = new Object();
	obj.settingsData = objForm;
	obj.settingsTypes = objSettingTypes; 
	var data = JSON.stringify(obj);
	
	$("#spanLoaderSave").show();
	$("#butSaveSettings").hide();
	
	//send request to save settings by ajax
	jQuery.ajax({
		   type: "POST",
		   url: g_self,
		   data: "action=saveSettings&data="+data,
		   success: function(response){
				$("#spanLoaderSave").hide();
				if(!isJSON(response)){
					debug(response);
					showSavingErrorText();
					return(false);
				}
				var objResponse = JSON.parse(response);
				if(objResponse.success == true){	//show success text
					$("#spanSavedText").show();
					setTimeout("restoreSaveButton()",750);
				}
				else showSavingErrorText();
		   },
		   error: function(){
			   $("#spanLoaderSave").hide();
			   showSavingErrorText();
		   }		
		});	
	
}

//-----------------------------------------------------
// restore settings
function restoreSettingsClick(){
	if(confirm("The settings will be restored to their defaults. Do you sure?") == false) return(false);
	
	$("#butRestoreSettings").hide();	
	$("#spanLoaderRestore").show();
	
	//send request to restore settings by ajax
	jQuery.ajax({
		   type: "POST",
		   url: g_self,
		   data: "action=restoreSettings",
		   success: function(response){
				if(!isJSON(response)){
					debug(response);
					showRestoreErrorText();
					return(false);
				}				
				var objResponse = JSON.parse(response);
				
				if(objResponse.success == true){	//show success text					
					$("#spanLoaderRestore").hide();
					$("#spanRestoredText").show();
					setTimeout("location.href='"+g_self+"'",500);
				}
				else showRestoreErrorText();				
		   },
		   error: function(){
			   showRestoreErrorText();
		   }		
		});
}
